#!/bin/bash

# 指定包含镜像 tar 包的目录
IMAGES_DIR="./images"

# 循环处理目录下的所有 tar 包
for TAR_FILE in ${IMAGES_DIR}/*.tar; do
  # 输出正在加载的镜像文件
  echo "Loading image from: ${TAR_FILE}"

  # 使用 docker load 加载镜像
  docker load -i ${TAR_FILE}

  # 检查 docker load 的返回状态
  if [ $? -eq 0 ]; then
    echo "Image loaded successfully."
  else
    echo "Failed to load image."
  fi
done

echo "All images loaded from ${IMAGES_DIR}"

